//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.0

import wesual.Controls 1.0
import wesual.data.Core 1.0

FocusScope {
    id : dropDown

    property Item           inputBox
    property Component      delegate
    property DocumentModel  model
    property int            activeIndex         : -1
    property int            itemInset           : 7
    property string         displayPropertyName
    property string         titlebarText
    property bool           titlebarClickable   : false
    property bool           willScroll          : false

    property alias          popupVisible        : popupAnchor.popupVisible

    signal titlebarClicked()
    signal accepted(int index)

    function show() {
        popupAnchor.show();
    }

    function hide() {
        popupAnchor.hide();
    }

    // Key handling
    function indexIncrement() {
        if (model.documents.length < 1)
            return;

        if (popupAnchor.popupItem) {
            popupAnchor.popupItem.index = (popupAnchor.popupItem.index + 1)
                    % model.documents.length;
        }
    }

    function indexDecrement() {
        if (model.documents.length < 1)
            return;

        if (popupAnchor.popupItem) {
            var index = popupAnchor.popupItem.index - 1;
            if (index < 0)
                index = model.documents.length - 1;

                popupAnchor.popupItem.index = index;
        }
    }

    function acceptValidIndex() {
        dropDown.accepted(popupAnchor.popupItem.index >= 0
                          ? popupAnchor.popupItem.index : undefined);
    }

    anchors {
        top : parent.bottom
        topMargin : -1
        left : parent.left
    }

    PopupAnchorItem {
        id : popupAnchor

        popup : Item {
            id : popupContainer

            property alias index : listView.activeIndex

            Connections {
                target : dropDown
                onActiveIndexChanged : listView.activeIndex = activeIndex;
                ignoreUnknownSignals : true
            }

            width  : inputBox ? inputBox.width : 200
            height : dropDown.height

            opacity : popupAnchor.popupVisible ? 1 : 0
            Behavior on opacity {
                NumberAnimation { duration : 150 }
            }


            Rectangle {
                id : bg
                anchors.fill : parent
                border  {
                    width : 1
                    color : UI.color(UI.PrimaryControlBorder)
                }
            }

            MouseArea {
                id : catchMouseToAvoidFlicking
                anchors.fill : parent
                hoverEnabled : true
            }

            Item {
                id : listDescription
                anchors.top : parent.top
                anchors.left : parent.left
                anchors.right : parent.right
                anchors.margins : bg.border.width


                height : titlebarText.length ? 33 : 0
                visible : height > 0

                Rectangle {
                    id : textWrapper
                    color : titlebarText.length ?
                                UI.color(UI.PrimaryHover) : UI.color(UI.PrimaryBase)
                    height : 26
                    anchors.top : parent.top
                    anchors.topMargin : 3
                    anchors.left : parent.left
                    width : parent.width

                    Text {
                        text : titlebarText
                        x : 9
                        width : parent.width
                        anchors.verticalCenter : parent.verticalCenter
                        font {
                            family : UI.fontFamily(UI.PrimaryFont)
                            weight : UI.fontWeight(UI.PrimaryFont)
                            pixelSize : 14
                        }
                        color : UI.color(UI.PrimaryTextColor)
                        elide : Qt.ElideRight
                    }
                }

                Rectangle {
                    id : bottomSpacer
                    width : parent.width
                    height : 1
                    anchors.top : textWrapper.bottom
                    anchors.topMargin : 3
                    color : UI.color(UI.SecondarySeparationLine)
                }

                MouseArea {
                    id : showMoreClick
                    anchors.fill : parent
                    onClicked: titlebarClicked()
                    enabled : titlebarClickable
                }
            }


            ScrollView {
                id : itemColumn

                anchors {
                    fill : parent
                    topMargin : 4 + listDescription.height// spacer for scrollbar
                    bottomMargin : 4
                    leftMargin : bg.border.width
                    rightMargin : bg.border.width
                }

                frameVisible : false
                ListView {
                    id : listView

                    property string displayPropertyName : dropDown.displayPropertyName
                    property bool   willScroll    : dropDown.willScroll
                    property int    activeIndex   : dropDown.activeIndex

                    width : parent.width + 2

                    signal accept(int index)
                    onAccept : dropDown.accepted(index);

                    model    : dropDown.model.documents.length > 0 ?
                                                   dropDown.model.documents : []
                    delegate : dropDown.delegate
                }
            }
        }
    }
}
